<?php
/**
* Partial that generates the markup for a <label> element.
*
* This partial generates the markup for the label <i>only</i> and is used by the {@link Field_markup_generator::label_markup() label_markup()} method.
*
* Form markup generator partials are designed to follow object-oriented-esque patterns of inheritance.  This partial will by default be used by 
* all of the children of the {@link Field_markup_generator} that do not have a partial named after their {@link Field_markup_generator::$_type type}.
* If you wish to override this partial in your application, please follow the instructions in the "Partials and Markup Generation" section of the
* {@link Field_markup_generator} class documentation.
*
* This partial uses the Codeigniter {@link form_label()} method from the CI Form Helper.  For information on extending or overriding CI helper methods, 
* see the {@link http://codeigniter.com/user_guide/general/helpers.html CI manual}.
*
* Like all {@link Field_markup_generator} partials, this partial expects to be passed a copy of the markup generator calling it, called $markup_generator.
* @package icarus
* @subpackage form-markup-generator
*
* @author M. Gibbs <gibbs_margaret@bah.com> Last updated 2012-08-02
*/

if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error->should_be_a_field_markup_generator($markup_generator);
	
if(!isset($label_attributes) || !is_array($label_attributes))
	$label_attributes = array();

if(!array_key_exists('class', $label_attributes) || !string_contains('sr-only', $label_attributes['class']))	
	$label_attributes = merge_attributes(array('class' => 'control-label '.implode(' ', $markup_generator->classes('-control-label'))), $label_attributes); 	

$label_text = $markup_generator->label_text;
if($markup_generator->required){
	$label_text .= ' <span class="req">*</span>';
	$label_attributes['title'] = 'The '.$markup_generator->referral_label.' field is required.';
}	

echo form_label($label_text, $markup_generator->id, $label_attributes); 